/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CRMWOLock.h,v 1.2 1999/09/17 04:20:45 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CRMWOLock_h	// [
#define Included_CRMWOLock_h

#include "pgpClassesConfig.h"
#include "CMutex.h"
#include "CSemaphore.h"

_PGP_BEGIN

// Class CRMWOLock

class CRMWOLock SMART_ERROR_INHERIT
{
	friend class CRMWOLock;

public:
	CRMWOLock();
	~CRMWOLock() { }

	virtual void	StartReading();
	virtual void	StopReading();

	virtual void	StartWriting();
	virtual void	StopWriting();

protected:
	CMutex		mMutex;
	CSemaphore	mBlockedReaders;
	CSemaphore	mBlockedWriters;

	PGPUInt32	mActiveReaders;
	PGPUInt32	mWaitingReader;
	PGPUInt32	mActiveWriters;
	PGPUInt32	mWaitingWriter;

	PGPBoolean	mWritersFirst;

	virtual void	ReleaseReaders();
	virtual void	ReleaseWriters();
};

_PGP_END

#endif	// ] Included_CRMWOLock_h
